






Apple IIGSt Icon Editor

Copyright Apple Computer, Inc. 1987
All rights reserved

By Dan Oliver














This document assumes that you are familiar with menus, windows, controls, and line edit.


Contents



Chapter 1 - Overview.............................................	Page 2

Chapter 2 - Getting Started in a Hurry..........................	Page 2

		Creating Icons............................................................	Page 3
		Creating Your Application Icon........................................	Page 4
		Creating Your Document Icon.........................................	Page 5
		Saving Your Icon File to Disk.........................................	Page 5

Chapter 3 - Fat Pixel Displays...................................	Page 6

Chapter 4 - Reference.............................................	Page 8

	Menu Bar
		About GS Icon Editor...................................................	Page 8
		New.......................................................................	Page 8
		Open.......................................................................	Page 8
		Save.......................................................................	Page 8
		Save as....................................................................	Page 8
		Quit........................................................................	Page 8
		Add New Icon...........................................................	Page 8
		Edit Extended Parameters...............................................	Page 8
		Remove...................................................................	Page 8
		Copy Image to Mask....................................................	Page 8
		Copy Mask to Image....................................................	Page 8
		Fill Image.................................................................	Page 8
		Fill Mask..................................................................	Page 8
		by Large Icon............................................................	Page 9
		by Small Icon............................................................	Page 9

	Buttons in Edit Extended Parameters Dialog
		Cancel.....................................................................	Page 9
		OK.........................................................................	Page 9

	Buttons in Edit Window
		Save Icon.................................................................	Page 9

	Line Edit Fields in Edit Extended Parameters Dialog
		Name to match...........................................................	Page 9
		File type to match........................................................	Page 10
		Aux........................................................................	Page 10
		Icon's Application Pathname...........................................	Page 10
		Width of icon.............................................................	Page 10
		Height of icon............................................................	Page 11


Chapter 5 - Icon Structure Definition...........................	Page 12

Chapter 6 - Finder & Application Interface.....................	Page 13




Chapter 1 - Overview

The Icon Editor is used to create icons that the Apple IIGS Finder can recognize.  The Finder will use the icons to set certain files apart from other files and to launch applications from document files.

How does the Finder know which files go with which icons?  The Finder can match files to icons by any combination of 3 fields.  The icon can match by file type, aux type, and filename.  The Finder keeps a list of icon blocks (an icon block is an ICONBLK structure that contains one or more icons).  The first list the Finder reads is FINDER.ICONS from the boot disk's ICON folder.  After that the Finder will add any icon block files that it finds in the ICON directory of inserted disks.  Additional blocks are added to the front of the list so that FINDER.ICONS is always the last block in the list.

When the Finder needs to match a file to an icon it starts with the first icon in the first block in the list.  A match can be accomplished by either an exact match or by use of a wildcard.  If all three fields in the icon match the file the file is given that icon.  If even one field does not match the Finder will try again with the next icon in the block.  The Finder will try again with the first icon in the next block in the list if there are no more icons in the block.  The last icon in the list is the last icon in FINDER.ICONS which is the generic document icon and will always match all 3 fields.





Chapter 2 - Getting Started in a Hurry

This chapter can be used to create a typical icon file for a application.  The goal of this chapter is to create one icon for your application and one icon for your data files.  The steps are very short and don't go into explanations.  The following chapters go into more detail about the Icon Editor and icon record structure.

If your application does not create documents skip the Creating Your Document Icon section.  If your application creates more then one type of document repeat Creating Your Document Icon section until you have created an icon for each type of document.


Creating Icons

Have an idea of what icons you want for your application and documents.  Drawing the shapes on graph paper can be a big help.  You will need two shapes for each icon, one for when it's viewed as large (any size you'd like, average about 16x16, maximum about 200x30 or so) and one when it's viewed as small (8x8).


Creating Your Application Icon

-	Create a directory (folder) named ICONS in the root directory of the disk that contains your application.

-	Run the ICON.EDITOR program on the ICON.EDITOR disk.

-	Select 'New' from the 'File' menu.

-	Select 'Add New Icon' from the 'Edit' menu.

-	Double click on the icon that just appeared in the Untitled window.  The edit window will come forward and take up the entire screen.

-	Select 'Edit Extended Parameters...' from the 'Edit' menu.  Entering extended parameters uses line edit fields and assumes you already know how line edit fields work.

-	Enter the following data into the following line edit fields: (See Chapter 4 "Line Edit Fields in Edit Extended Parameters Dialog" for more information.)


Name to match:	Filename of your application.
File type to match: $	00B3
Aux: $	0000 (don't touch)
Icon's Application:	(blank, don't touch)
Width of icon:	Width of your icon shape in pixels, even numbers only.
Height of icon:	Height of your icon shape in pixels.


-	Select the 'OK' button with the mouse.

-	Edit the 'Image:' fat pixel display.  See  Chapter 3 for more information about editing Fat Pixel Displays.

-	Select 'Copy Image to Mask' from the 'Edit' menu.  Copies all pixels from the Image fat pixel display into the Mask fat pixels display.  White pixels are copied as white and all other colors are copied as black.  Every black pixel in the Mask will allow the corresponding pixel in the Image to be displayed in the icon.

-	Change white pixels in the Mask fat pixel display to black for every pixel in the Image display that you want to display in the final icon.

-	Click on the 'Save Icon' button in the Edit window.

-	Select 'by Small Icon' from the 'View' menu.

-	Edit the small edit Image and Mask just like you did for the large icon Image and Mask in the last few steps.

-	Click on the 'Save Icon' button in the Edit window.

-	Select 'by Large Icon' from the 'View' menu.

-	Click on the Zoom box in the Edit window.

-	Click on the Untitled window to bring it to the front.  Your application icon will be displayed in the Untitled window.

Creating Your Document Icon

-	Select 'Add New Icon' from the 'Edit' menu.

-	Double click on the icon that just appeared in the Untitled window.  The edit window will come forward and take up the entire screen.

-	Select 'Edit Extended Parameters...' from the 'Edit' menu.

-	Enter the following data into the following line edit fields:

Name to match:	Type * (that is, one character, upper case 8).
File type to match: $	File type of the document file.
Aux: $	Aux type if all your documents will have the same aux type.
Icon's Application:	Entire pathname of your application on the disk you ship.
Width of icon:	Width of your icon shape in pixels, even numbers only.
Height of icon:	Height of your icon shape in pixels.


-	Select the 'OK' button with the mouse.

-	Edit the 'Image:' fat pixel display.

-	Select 'Copy Image to Mask' from the 'Edit' menu.

-	Change white pixels in the Mask fat pixel display to black for every pixel in the Image display that you want to display in the final icon.

-	Click on the 'Save Icon' button in the Edit window.

-	Select 'by Small Icon' from the 'View' menu.

-	Edit the small edit Image and Mask just like you did for the large icon Image and Mask in the last few steps.

-	Click on the 'Save Icon' button in the Edit window.

-	Select 'by Large Icon' from the 'View' menu.

-	Click on the Zoom box in the Edit window.

-	Click on the Untitled window to bring it to the front.  Your document icon will be displayed in the Untitled window.


Saving Your Icon File to Disk

-	Select 'Save as...' from the file menu.

-	Open the ICONS directory in your application disk.

-	Type the name of your icon file.  A good name for your icon file would be the name of your application with .ICONS appended to the end.  The icon file must be in a directory called ICONS in the root of your application disk.

Chapter 3 - Fat Pixel Displays

The following diagram shows where the Fat Pixel Displays and the Color Bar are located in the Edit window.


Fat Pixel displays are used to change the shape and colors of graphic images, icons in this case.  Inside a fat pixel display are little rectangles.  Each rectangle corresponds to a pixel in the image.  The color of each pixel can be selected by you to create the final image and shape.

The Icon Editor uses two different types of fat pixel displays to create an icon.  The first is the one labeled 'Image'.  The image display can edited using 16 colors.  The other display is labeled 'Mask'.  The mask display can only be edited with two colors, black and white.  When editing the Mask image every color is considered black except for white.

To change pixels you must first select a color from the Color Bar by clicking the mouse over a color.  Then move the cursor over the pixel in the fat pixel display you want to change and click.  The pixel will now change color to the color you selected from the Color Bar.


Short Cut:	In addition to picking up color from the Color Bar you can also pick up colors directly from the fat pixel display.  To select a color from the fat pixel display click on pixel on the desired color while holding down the Open Apple key (the key that isn't the option key).  Then release the Open Apple key.  The current color will now be the new color.


If you make a mistake, click again on the wrong pixel and the pixel that was there (no matter what color) will come back.  Clicking on color that has been laid down since the last color selection will undo that pixel.  You will be able to undo pixels until you change colors using either the color bar or the short cut.  Changing colors takes a snap-shot of the current image and it is from the snap-shot image that pixels will be recovered.

To change a lot of pixels you can drag over (move the cursor while holding down the button) the pixels you wish to change.  Each pixel you touch with the cursor will be changed.  To change all the pixels you can select one of four items in the 'Edit' menu outlined below.


Copy Image to Mask	Copies all pixels from the Image fat pixel display into the Mask fat pixels display.  White pixels are copied as white and all other colors are copied as black.  Every black pixel in the Mask will allow the corresponding pixel in the Image to be displayed in the icon.

Copy Mask to Image 	Will copy every pixel in the Mask fat pixel display into every corresponding pixel in the Image fat pixel display.

Fill Image	Every pixel in the Image fat pixel display will become the current color (current color is the last selected color).

Fill Mask 	Every pixel in the Mask fat pixel display will become white if the current color is white, otherwise they will become black (current color is the last selected color).



Chapter 4 - Reference


Menu Bar

About GS Icon Editor...

	Copyright notice.

New
	Creates an icon display window that can be used to create icon files.  See 'Add New Icon' for adding icons to the window.

Open...
	Creates an icon display window that displays an existing icon file.

Save
	Saves the icon file in the top most window to the same name the file originally came from.

Save as...
	Saves the icon file in the top most window to a new name and location.

Quit
	Exits the Icon Editor.

Add New Icon
	Adds a generic icon to the end of the icon list in the top most window.

Edit Extended Parameters...
	Brings up a dialog window that allows editing of the icon currently being edited.  The items that can be edited in this window are the size of the large icon, what filename, file type and aux type to associate with the icon, and what application to launch when the icon is opened in the Finder.

Remove
	Removes the icon currently being edited from the icon list it came from.

Copy Image to Mask
	Copies all pixels from the Image fat pixel display into the Mask fat pixels display.  White pixels are copied as white and all other colors are copied as black.  Every black pixel in the Mask will allow the corresponding pixel in the Image to be displayed in the icon.

Copy Mask to Image 
	Will copy every pixel in the Mask fat pixel display into every corresponding pixel in the Image fat pixel display.

Fill Image
	Every pixel in the Image fat pixel display will become the current color (current color is the last selected color).

Fill Mask
 	Every pixel in the Mask fat pixel display will become white if the current color is white, otherwise they will become black (current color is the last selected color).

by Large Icon
	Change the view of every window to view by large icon.  Allows editing of the large icon in the Edit window.

by Small Icon
	Change the view of every window to view by small icon.  Allows editing of the small icon in the Edit window.


Buttons

Edit Extended Parameters Dialog

Cancel
	Removes the dialog window and does not use any of the changes made in the window since it was last displayed.

OK
	Removes the dialog window and accepts the data in the window.  The data in the window is not put into the icon list at this time, the 'Save Icon' button in the edit window will do that.


Edit Window

Save Icon
	Saves the current extended parameters and the current icon shape (large or small) into the icon list that the icon came from.


Line Edit Fields in Edit Extended Parameters Dialog

Name to match:

	This field contains the filename that should be associated with the icon image.  The '*' character can be used as a wildcard character.  Here are some examples of strings that can be used for matching:


SOURCE.ASM	Only filenames that match this string exactly will have the icon being edited.

*.ASM	Only filenames that end with the characters '.ASM' will have the icon being edited.

*ASM	Only filenames that end with the characters 'ASM' will have the icon being edited.

SOURCE*	Only filenames that start with the characters 'SOURCE' will have the icon being edited.

*	All filenames will have the icon being edited.


Suggestion:	For this field type a '*' for document icons and the complete application name for application icons.  Typing a string for document icons forces the user to always name your documents to your convention.  One time when a string for a document icon would make sense is when it is for documents that are created by your application and user does not create.



File type to match: $

	This field contains the file type that should be associated with the icon image.  Either a hexadecimal number can be entered or 0000.  A value of zero here will associate files of any file type to this icon.  See ProDOS documentation about file types for more information.


Suggestion:	For this field is to enter the file type.  Field types for applications should be $00B3.  The file type is the best way to associate files to icons and should not be left as zero.



Aux: $

	This field contains the file aux type that should be associated with the icon image.  Either a hexadecimal number can be entered or 0000.  A value of zero here will associate files of any aux type to this icon.  See ProDOS documentation about aux types for more information.


Suggestion:	For application icons leave this field 0000.  For document icons that do not have special file types but do have special aux types, enter the special aux type.  If your document files do not have a special aux type leave this field as 0000.



Icon's Application Pathname

	This field contains the complete pathname of the application that should be launched if the icon being edited should be opened in the Finder.  Generally, this field would contain the pathname of the application on the disk being sold.  For example, if you have an application named APPLICATION on a disk named DISK in a directory named FOLDER this field should have the string /DISK/FOLDER/APPLICATION.  


Suggestion:	For this field is to enter the pathname of the application for icons that will be associated with files that contain data that is created by the user while in the application.  

	This field should be left blank (no characters) if the icon will be associated with an application.



Width of icon:

	This field defines the width of the icon image.  The number entered must be even and is the number of little rectangles wide the obese bits display will be.  Changing this field will cause the current images in the obese bits display to be lost.Those of you know how the GS represents color may find this parameter a little confusing because the Icon Editor represents pixels or obese bits as 4 bits per pixel even through we are in 640 mode.


Suggestion:	For this field enter a decimal number in the range of 10 to 30 with 16 being an average.  Icons smaller or larger than this range could make your icon look out of place.  Very large icons (those containing 2000 or more pixels) can make the system fail.



Height of icon:

	This field defines the height of the icon image.  The number entered is the number of little rectangles high the obese bits display will be.  Changing this field will cause the current images in the obese bits display to be lost.


Suggestion:	For this field enter a decimal number in the range of 10 to 30 with 16 being an average.  Icons smaller or larger than this range could make your icon look out of place.  Very large icons (those containing 2000 or more pixels) can make the system fail.




Chapter 5 - Icon Structure Definition

This section describes how icons are represented internally.  It is not necessary to read or understand this section in order to use the Icon Editor.  This information is provided for programmers that may want to write their own icon editors or use icon files in their own applications.

Icon images are defined by a structure called an ICONBLK.  The ICONBLK contains a header that describes where the block came from and where the next block is.  After the header is a list of ICONDATA structures each of which describes one icon.  Each ICONDATA block contains a header that describes general information about the icon like what file type and name should be associated with the icon.  Following the header in each ICONDATA are two ICON structure.  Each ICON structure describes the actual icon image.  The first ICON structure in the ICONDATA structure describes a large icon, the second ICON describes a small icon.  In the Finder the large icon is displayed when 'by Icon' is selected from the View menu and the small icon is displayed when any of the other items in the View menu is selected.


ICONBLK record:

	IBlkNext		LONG			Handle of next ICONBLK record, zero terminates list.
	IBlkID		WORD			ID number for this type of ICONBLK.
	IBlkPath		LONG			Handle of pathname that block came from.
	IBlkName	BYTE[16]		Name of file block came from.
	IBlkIcons	ICONDATA[n]	List of icon data records.


	ICONDATA record:

		iDataLen		WORD		Length of this ICONDATA record, zero terminates list.
		iDataBoss	BYTE[64]	Name of application that owns this icon.
		iDataName	BYTE[16]	Name of file or files associated with this icon.
		iDataType	WORD		File type associated with this icon.
		iDataAux		WORD		File aux type associated with this icon.
		iDataBig		ICON			Normal size icon image data.
						ICON			Small size icon image data.

		ICON record:

			imType		WORD	Flags, zero.
			imSize		WORD	Number of bytes in image buffer (mask size also).
			imHeight		WORD	Height of icon image and mask in pixels.
			imWidth		WORD	Width of icon image and mask in pixels (4 bits per pixel).
			imImage		BYTE[n]	Icon image data.
							BYTE[n]	Icon mask data.



Chapter 6 - Finder & Application Interface

This section describes how an application can interface with the Finder.

When a user opens one or more document files from the Finder, the Finder looks for and launches the application that created those document files.  In addition to launching the application the Finder also passes a list of the opened documents to the Message Center.  Your application can then ask the Message Center what document files were opened.

Reading the List of Opened Document Files

After your application has started and you have performed necessary initialization perform the following steps.



1.)	Allocate a handle.  The size of the handle can be any size (10 bytes or so) and its attributes should be zero (unlocked, movable, anywhere).

			pha		Space for result.
			pha
			pea	0	Pass size.
			pea	10	
			pei	<MyID	Pass ID number.
			pea	0	Pass attributes.
			pea	0	Pass address of memory (none).
			pea	0
			_NewHandle
			pla
			sta	<messageHand
			pla
			sta	<messageHand+2

2.)	Next, call the Message Center and ask for a pathname list message if it has one.  (The Message Center is part of the Tool Locator and requires no additional initialization.)

			pea	2	Return a message command.
			pea	1	Requesting a message about files.
			pei	<messageHand+2	Pass handle to put message into.
			pei	<messageHand
			_MessageCenter
			bcc	OK	Make sure there is a message and
					that there was no error.

			pei	<messageHand+2	If there was no message, or an
			pei	<messageHand	error, the handle should be freed
			_DisposeHandle	and your application can continue
					like no document was opened.

3.)	Process the message.  The format of the Files Message is as follows:


	messNext	LONG	Handle of next message (don't use).
	messType	WORD	Should be 1 for Files Message.
	messData	WORD	0 if the documents were opened, 
				1 if Print was selected for the documents.
			STRG[n]	Array of pathnames, length byte first.
				A string with a length of zero terminates the list.


			ldy	#2	Dereference the message.
			lda	[<messageHand],y	You may also want to lock it.
			sta	<message+2
			lda	[<messageHand]
			sta	<message

			ldy	#messType	Index to message type.
			lda	[<message],y
			cmp	#1	Must be a Files Message.
			bne	error

			ldy	#messData+2	Index to first pathname.
		loop	sep	#$30	8 bit registers.
			LONGA OFF
			LONGI OFF
	
			ldx	#$FF	Move pathname into common area.
		cloneLoop	inx
			lda	[<message],y
			sta	pathname,x
			iny
			cpx	pathname	
			bne	cloneLoop
	
			rep	#$30	16 bit registers.
			LONGA ON
			LONGI ON

			lda	pathname	Is this the last pathname?
			and	#$00FF
			beq	done

			phy		Save index into message buffer.
					pathname = document's full path.
			ldy	#messData	Index to print flag.
			lda	[<message],y
			bne	printIt

			jsr	openDocument	Perform whatever operation your
			bra	next	application does to documents.

		printIt	jsr	printDocument	Print the document.

		next	ply		Get index into message buffer.
			bra	loop	Make sure the handle didn't move.

		done	pei	<messageHand+2	Free the message handle.
			pei	<messageHand	
			_DisposeHandle	

		--------------------------------------

		pathname	ds	256	The maximum length of pathnames
					is 256 bytes including length
					byte.


4.)	The last step is to delete the message from the Message Center.  This must be done so your application, or some other application, doesn't reuse the message if the next application isn't launched from the Finder.

			pea	3	Delete message command.
			pea	1	Delete Files messages only.
			pea	0	No handle required.
			pea	0
			_MessageCenter



